function showresults(modnr)

%%%% This matlab-file reads output generated by int_frost_10.c, 
%%%% displays the results and saves to mat-format for later use.

close all;

%read from file
fid = fopen(['../source/frost_res_',num2str(modnr),'.dat']);
nHs = fread(fid,1,'int');
nT0 = fread(fid,1,'int');
Hsv = fread(fid,[nHs,1],'double');
T0v = fread(fid,[nT0,1],'double');
Ci = fread(fid,[nHs,nT0],'double');
Tr = fread(fid,[nHs,nT0],'double');
fclose(fid);

%normalize Ci
%Ci = Ci/max(Ci(:));

%create mesh for plotting
[T0,Hs] = meshgrid(T0v,Hsv);

%plot frost cracking
set(gcf,'units','centimeters','position',[5,20,30,20]);

%plot Ci
hold on; box on;
v = linspace(0.01*max(Ci(:)),0.99*max(Ci(:)),30);
[c,h] = contourf(T0,Hs,Ci,v,'linestyle','none');
axis([-15,15,0,6]); %caxis([0,0.9]);
colorbar
xlabel('MAT'); ylabel('Sediment thickness');
hold off;

%plot Transport
figure(2)
set(gcf,'unit','centimeters','position',[40,20,30,20]);
hold on; grid on; box on;
contourf(T0,Hs,Tr,30); 
xlabel('MAT'); ylabel('Sediment thickness');
hold off;

%save for later use
eval(['save periglacial_input_mod',num2str(modnr),'.mat Hsv T0v Ci Tr']);